% ALPHA ELECTRIC MOTOR DEFINITION
% Generated 11-Sep-2023 15:07:09

% SUGGESTED CITATION:
% EST 2010 Toyota Prius 60kW 650V MG1 EMOT - ALPHA Map Package. Version 2023-09. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
mg = class_REVS_emachine_geared();
mg.name =  'EST 2010 Toyota Prius 60kW 650V MG1 EMOT'; 
mg.source_filename = mfilename;

% Physical Description
mg.electrical_source =  'propulsion'; 
mg.inertia_kgm2 =  0.0056227713562499995; 
mg.type = enum_emachine_type.Motor;
mg.gear.ratio =  1; 
mg.gear.efficiency_norm =  1; 

% Capacity Limits
mg.max_speed_radps =  1413.7166941154069; 
mg.max_torque_Nm =  207; 
mg.max_motor_power_W =  60000; 
mg.max_generator_power_W =  60000; 
mg.positive_torque_limit_Nm = class_REVS_dynamic_lookup;
mg.positive_torque_limit_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.positive_torque_limit_Nm.axis_1.breakpoints = [	    -1427.8538610565611	   -1413.7166941154069	   -1327.0473197136373	   -1071.4487114419444	   -898.40887060548050	   -773.48965966454955	   -679.06860379921011	   -605.19190953973566	   -545.81232674049500	   -497.04389682415115	   -456.27559045663583	   -421.68808398251099	   -391.97483108979321	   -366.17329633055812	   -343.55872593958787	   -323.57499276213832	   -305.78824968415296	   -289.85507246376812	    0.0000000000000000	    289.85507246376812	    305.78824968415296	    323.57499276213832	    343.55872593958787	    366.17329633055812	    391.97483108979321	    421.68808398251099	    456.27559045663583	    497.04389682415115	    545.81232674049500	    605.19190953973566	    679.06860379921011	    773.48965966454955	    898.40887060548050	    1071.4487114419444	    1327.0473197136373	    1413.7166941154069	    1427.8538610565611		]; 
mg.positive_torque_limit_Nm.axis_2.signal =  'emach_voltage_V'; 
mg.positive_torque_limit_Nm.axis_2.breakpoints =  650; 
mg.positive_torque_limit_Nm.table = [	     0.0000000000000000	    42.441318157838758	    45.213157894736838	    55.998947368421057	    66.784736842105247	    77.570526315789493	    88.356315789473683	    99.142105263157887	    109.92789473684211	    120.71368421052631	    131.49947368421053	    142.28526315789475	    153.07105263157894	    163.85684210526315	    174.64263157894737	    185.42842105263156	    196.21421052631578	    207.00000000000000	    207.00000000000000	    207.00000000000000	    196.21421052631578	    185.42842105263156	    174.64263157894737	    163.85684210526315	    153.07105263157894	    142.28526315789475	    131.49947368421053	    120.71368421052631	    109.92789473684211	    99.142105263157887	    88.356315789473683	    77.570526315789493	    66.784736842105247	    55.998947368421057	    45.213157894736838	    42.441318157838758	    0.0000000000000000		]; 

% Losses & Efficiency
mg.electric_power_W = class_REVS_dynamic_lookup;
mg.electric_power_W.axis_1.signal =  'emach_spd_radps'; 
mg.electric_power_W.axis_1.breakpoints = [	    -1361.3568165555769	   -1256.6370614359173	   -1151.9173063162575	   -1047.1975511965977	   -942.47779607693792	   -837.75804095727813	   -733.03828583761833	   -628.31853071795865	   -523.59877559829886	   -418.87902047863895	   -314.15926535897938	   -209.43951023931945	   -104.71975511965972	    0.0000000000000000	    104.71975511965972	    209.43951023931945	    314.15926535897938	    418.87902047863895	    523.59877559829886	    628.31853071795865	    733.03828583761833	    837.75804095727813	    942.47779607693792	    1047.1975511965977	    1151.9173063162575	    1256.6370614359173	    1361.3568165555769		]; 
mg.electric_power_W.axis_2.signal =  'emach_trq_Nm'; 
mg.electric_power_W.axis_2.breakpoints = [	    -200.00000000000000	   -190.00000000000000	   -180.00000000000000	   -170.00000000000000	   -160.00000000000000	   -150.00000000000000	   -140.00000000000000	   -130.00000000000000	   -120.00000000000000	   -110.00000000000000	   -100.00000000000000	   -90.000000000000000	   -80.000000000000000	   -70.000000000000000	   -60.000000000000000	   -50.000000000000000	   -40.000000000000000	   -30.000000000000000	   -15.000000000000000	    0.0000000000000000	    10.000000000000000	    20.000000000000000	    30.000000000000000	    40.000000000000000	    50.000000000000000	    60.000000000000000	    70.000000000000000	    80.000000000000000	    90.000000000000000	    100.00000000000000	    110.00000000000000	    120.00000000000000	    130.00000000000000	    140.00000000000000	    150.00000000000000	    160.00000000000000	    170.00000000000000	    180.00000000000000	    200.00000000000000		]; 
mg.electric_power_W.table = [
    289089.20593803411	    260287.68783703394	    245886.31198532184	    231484.57587825140	    217082.54817290459	    202680.56167363506	    188279.32644923098	    173880.03978661777	    159484.47853237166	    145095.04933546839	    130714.76013857922	    116347.06331261322	    101995.51016254206	    87663.153996351743	    73351.654416933117	    59060.084088232368	    44783.541872393711	    30511.858398142849	    16228.966647891046	    2352.7841194099710	   -17433.266760237842	   -36523.088716737955	   -49298.482510351438	   -62085.820574877558	   -74872.905184812276	   -87653.174701753887	   -100424.05205419019	   -113185.47773423072	   -125938.76428721282	   -138685.78716448147	   -151428.46748799764	   -164168.48122536647	   -176907.12919196757	   -189645.31203781351	   -202383.56736759766	   -215122.13888651165	   -227861.05836378795	   -240600.22972962281	   -253339.51076458493	;
    267071.12992103695	    240479.53555049002	    227184.35500592654	    213889.54644239575	    200595.07026634066	    187300.64536337255	    174005.64257961366	    160708.98658470347	    147409.08963676987	    134103.85948612355	    120790.84918339782	    107467.64791292706	    94132.644426698243	    80786.316585251174	    67433.188967374997	    54084.515795723171	    40761.527024509916	    27498.636512627516	    14470.750115211407	    1736.0744463647693	   -16743.859404853905	   -34472.073689135505	   -46173.083097492199	   -57841.921502006597	   -69505.448682601753	   -81178.224905628260	   -92866.472480387369	   -104571.30585508735	   -116291.08559325122	   -128022.98520477637	   -139763.94363908953	   -151511.18184635401	   -163262.43353441067	   -175016.00268083991	   -186770.72532398478	   -198525.88506447474	   -210281.11115574016	   -222036.27401571421	   -233791.38399349677	;
    245067.42641398858	    220666.04124637228	    208466.16831732768	    196266.81915756915	    184068.03331661716	    171869.64052855870	    159671.18747595130	    147471.89381470025	    135270.65052737662	    123066.06795837868	    110856.56423984913	    98640.451281974005	    86415.919262234529	    74180.739383235123	    61931.406837647861	    49661.361815723554	    37357.925214803807	    24997.794168962806	    13000.962757487947	    1302.4806849416564	   -15648.283778590583	   -31609.501602426626	   -42301.167821370691	   -53007.035862185410	   -63720.180059329774	   -74439.289430266435	   -85165.022698057786	   -95898.109002940982	   -106638.61798811246	   -117385.88954246900	   -128138.75735216393	   -138895.84284735634	   -149655.80593768487	   -160417.51092028560	   -171180.10637639835	   -181943.03613694379	   -192706.00308690296	   -203468.90515502513	   -214231.75758093849	;
    223078.09915685249	    200845.96417872392	    189729.94139404796	    178614.02146955294	    167498.37286612298	    156383.24363978853	    145268.92014552478	    134155.62338740777	    123043.30394730142	    111931.28418064433	    100817.69057448581	    89698.633279495451	    78567.146077035766	    67412.028294918942	    56216.960077877389	    44960.603857572503	    33618.812739396220	    22527.677995015136	    11715.442187846134	    1120.5782258726379	   -14343.052244836517	   -29118.605369709290	   -38651.826369982577	   -48279.874562840509	   -57973.585359033903	   -67707.980651765436	   -77464.598237459402	   -87231.333799046595	   -97001.168008627705	   -106770.63655450258	   -116538.47964976296	   -126304.62749214956	   -136069.52384799221	   -145833.72404537647	   -155597.68929771410	   -165361.70906746085	   -175125.90045019763	   -184890.25008284434	   -194654.67698513149	;
    201084.05254929553	    181020.44043219136	    170986.43915251645	    160950.78156690139	    150912.70456131763	    140871.44239752894	    130826.26349266036	    120776.46425887659	    110721.34755548020	    100660.25576074426	    90592.778053136601	    80519.286465279394	    70441.935618061238	    60366.129446819468	    50302.155106334772	    40266.205949805590	    30279.465463232274	    20412.883754535243	    10680.960306662504	    1144.1883231888901	   -12733.418145931038	   -26173.309659778737	   -34996.749310969280	   -43770.406326854798	   -52515.612023864982	   -61248.527170280526	   -69979.247905748562	   -78712.947149103318	   -87451.621396442366	   -96195.619271929492	   -104944.64668856503	   -113698.26746206296	   -122456.05536270345	   -131217.57017239393	   -139982.28907379266	   -148749.56899808918	   -157518.66860137932	   -166288.82836238126	   -175059.39302718613	;
    179065.14930323500	    161182.94548294871	    152237.46440137632	    143288.38148217986	    134333.62811321934	    125371.07704067809	    116398.99624583389	    107416.57970038698	    98424.474900058587	    89425.158500059959	    80422.957243872515	    71423.518035766116	    62432.683883935417	    53455.134315578180	    44493.877551521582	    35547.982717520383	    26757.857396337015	    18081.969551575647	    9546.5038106430165	    1121.2957961544753	   -11312.533520664139	   -23432.065168875837	   -31368.644579743086	   -39149.615374776324	   -46912.965522316459	   -54658.484865818027	   -62389.820749705177	   -70112.145492199124	   -77831.702714398329	   -85554.451791458603	   -93284.943055572498	   -101025.79634044869	   -108777.73721801012	   -116539.98681068476	   -124310.79466728077	   -132087.96065300400	   -139869.26307240894	   -147652.77046916573	   -155437.05421917560	;
    157052.40449023707	    141347.17399397033	    133493.46670840020	    125638.37841603288	    117780.16178368004	    109916.05231541433	    102042.22110214684	    94153.989118802114	    86246.500653089475	    78316.079992197323	    70362.440787374304	    62391.719872640650	    54419.744202188798	    46471.824586612624	    38575.759692657077	    30853.501117286418	    23250.237673131636	    15723.674255015643	    8258.5499994565325	    888.24714319005614	   -9983.9231973447640	   -20672.210271567132	   -27710.667751910925	   -34630.657196748034	   -41368.273726273954	   -48051.646737103532	   -54710.237880864915	   -61370.917163507584	   -68050.529675419064	   -74755.648190228108	   -81486.009525852409	   -88237.714497873501	   -95005.567309088292	   -101784.52075005378	   -108570.39993126557	   -115360.13479257301	   -122151.70616878133	   -128943.95576744604	   -135736.35183216885	;
    135178.87527210047	    121598.37440638476	    114808.20947730356	    108018.47859457528	    101229.88043111708	    94443.175834588794	    87658.627718360425	    80874.910646784716	    74087.243670853000	    67284.678938877521	    60444.878337397415	    53526.283682586538	    46458.719075230605	    39622.026000814505	    32986.427803660772	    26457.480837195682	    20015.513486858905	    13678.187796526199	    7380.7955749581224	    1109.3157407549104	   -8270.6525007638720	   -17630.626095616673	   -23739.776154107174	   -29765.600099244319	   -35679.676213952327	   -41381.900690429902	   -46842.086162198713	   -52461.055845550618	   -58164.968855852640	   -63910.149983195261	   -69673.114619110929	   -75442.275268258250	   -81212.420409115570	   -86981.871523601978	   -92750.559516977009	   -98518.908400100656	   -104287.29441500150	   -110055.86806606986	   -115824.57059835564	;
    113603.06512722879	    102090.26526982724	    96324.760851235624	    90553.045487521595	    84771.970723500039	    78978.396333095108	    73169.432748602499	    67341.830503591875	    61491.122228759014	    55609.094512031588	    49687.836802736048	    43935.146751275315	    38344.340380332622	    32868.194984388574	    27446.003047980001	    22104.257621926183	    16815.246617861852	    11454.136727210165	    6062.1784932014434	    771.24084547254245	   -6920.2058491570369	   -14537.104522813926	   -19724.719688312500	   -24851.070259592714	   -29891.323132588972	   -34874.888378006523	   -39738.141042704396	   -44431.485702615566	   -48948.688741612292	   -53510.161163885714	   -58107.486559776175	   -62732.151429605423	   -67379.701916075486	   -72046.888910008871	   -76730.533752695206	   -81426.829408388308	   -86131.627269465971	   -90841.590553504502	   -95553.637170591697	;
    92481.485151625107	    82937.029222291429	    78154.456102104494	    73359.923070293109	    68547.831523389774	    63714.213011738007	    58858.189684858582	    53963.881522823642	    49196.910115134335	    44582.836333915795	    40109.668045274171	    35682.321691280456	    31268.856393307975	    26888.433193104996	    22508.022082020892	    18125.851540684398	    13751.025503138613	    9366.4470385174827	    4969.3123632218521	    700.00054110766371	   -5379.2334212558189	   -11317.684579816028	   -15313.524484746018	   -19301.276076639089	   -23289.363941235126	   -27276.917952705833	   -31229.740640884069	   -35168.030645110928	   -39058.219808839451	   -42800.382996504173	   -46381.784259870547	   -49829.553498324000	   -53320.056959088295	   -56842.716818145978	   -60394.591891720287	   -63970.116057226405	   -67562.246622763589	   -71161.559690311027	   -74761.964026593691	;
    72182.796432218689	    64267.663728262742	    60511.805138804935	    56556.092433669364	    52672.578258104040	    48880.863187967807	    45136.158391511490	    41542.997592225933	    37911.623798904271	    34328.681623613280	    30793.452536997644	    27322.281216507723	    23919.706560006747	    20538.456568361562	    17178.032965905611	    13840.516480680457	    10494.811226248192	    7148.5035876653546	    3821.8290211896851	    609.39319356760359	   -3932.1150776949521	   -8298.0854318721595	   -11226.685075946807	   -14164.030825866843	   -17076.264320260998	   -19966.219843226820	   -22833.740645233793	   -25629.260916916668	   -28357.532536543509	   -31035.697371587521	   -33662.982274564631	   -36330.364994308919	   -38838.743400365580	   -41298.389264763631	   -43662.819594502209	   -45949.860544464653	   -48429.987919985753	   -50771.484689356774	   -53069.510340597459	;
    53316.719651374595	    46742.075095073822	    43426.405554908022	    40087.600652161884	    36937.253542677121	    34032.845871196383	    31334.314698492013	    28695.849183630595	    26213.481284249450	    23720.993466613720	    21294.932282720176	    18956.045319803434	    16482.446399690525	    14082.175996125516	    11754.242687338914	    9456.2873082042897	    7169.7524587270709	    4883.2551709275876	    2624.3211848686387	    466.03983166383273	   -2529.6521396398134	   -5349.7697921363406	   -7243.4698730731907	   -9125.3094561123125	   -10974.820629329339	   -12748.047490004334	   -14444.244591489065	   -16281.912307105631	   -18028.064189001194	   -19704.472642251665	   -21391.460747388293	   -22914.351360919271	   -24373.902608922894	   -25618.185050184173	   -26610.132036190706	   -27416.842626797166	   -28236.231379385597	   -28902.790481775148	   -29981.807466309903	;
    31792.843962739200	    26474.370513805425	    24423.482730912689	    22428.910380880996	    20819.467236543591	    19065.851699256673	    17456.188275151180	    15923.723880721858	    14392.399042504812	    12912.307133201979	    11501.489070153131	    10149.242935637281	    8835.4902922422734	    7557.6926940568919	    6303.2206060540275	    5069.3598051163553	    3848.0972654216562	    2634.4681682690584	    1442.1263412135411	    336.55098019985081	   -1105.0698459543930	   -2397.6701506685085	   -3263.0933356202017	   -4115.3986150424662	   -4945.1343527668132	   -5750.1046358720114	   -6517.3571680480582	   -7244.2521230463317	   -7909.6602729795613	   -8502.2680566358613	   -9040.8826675548316	   -9577.9897790950836	   -10034.252994571512	   -10342.250085511469	   -10808.909031925739	   -10868.384744076604	   -10790.154993879762	   -10206.820413208063	   -9562.6638739064347	;
    11028.842584274909	    8480.0716678664794	    6851.8436125128474	    5710.2499520238298	    5019.9868548254626	    4771.5093524785361	    4353.3683946881765	    3885.4823770433341	    3567.7615691210244	    3103.3653948322776	    2581.9951962589321	    2111.0375004568659	    1725.2786440582886	    1419.5999931443023	    1172.7977667503108	    964.40866234486839	    776.51843573707606	    600.25864925346218	    361.74885130110624	    270.19209094948644	    314.46272656123091	    426.20043516412625	    572.61963543957211	    737.99865314719329	    917.19446768263492	    1116.3229135396648	    1351.7997348001395	    1643.0675072753472	    2010.4326184606582	    2458.9268413178370	    2955.6555999909829	    3398.6931373561115	    3702.8871833756225	    4150.4664003716243	    4548.3962140971453	    4775.4994831459644	    5400.1070600069461	    6410.7348215112934	    10352.058785281493	;
   -9562.6638739064347	   -10206.820413208063	   -10790.154993879762	   -10868.384744076604	   -10808.909031925739	   -10342.250085511469	   -10034.252994571512	   -9577.9897790950836	   -9040.8826675548316	   -8502.2680566358613	   -7909.6602729795613	   -7244.2521230463317	   -6517.3571680480582	   -5750.1046358720114	   -4945.1343527668132	   -4115.3986150424662	   -3263.0933356202017	   -2397.6701506685085	   -1105.0698459543930	    336.55098019985081	    1442.1263412135411	    2634.4681682690584	    3848.0972654216562	    5069.3598051163553	    6303.2206060540275	    7557.6926940568919	    8835.4902922422734	    10149.242935637281	    11501.489070153131	    12912.307133201979	    14392.399042504812	    15923.723880721858	    17456.188275151180	    19065.851699256673	    20819.467236543591	    22428.910380880996	    24423.482730912689	    26474.370513805425	    31792.843962739200	;
   -29981.807466309903	   -28902.790481775148	   -28236.231379385597	   -27416.842626797166	   -26610.132036190706	   -25618.185050184173	   -24373.902608922894	   -22914.351360919271	   -21391.460747388293	   -19704.472642251665	   -18028.064189001194	   -16281.912307105631	   -14444.244591489065	   -12748.047490004334	   -10974.820629329339	   -9125.3094561123125	   -7243.4698730731907	   -5349.7697921363406	   -2529.6521396398134	    466.03983166383273	    2624.3211848686387	    4883.2551709275876	    7169.7524587270709	    9456.2873082042897	    11754.242687338914	    14082.175996125516	    16482.446399690525	    18956.045319803434	    21294.932282720176	    23720.993466613720	    26213.481284249450	    28695.849183630595	    31334.314698492013	    34032.845871196383	    36937.253542677121	    40087.600652161884	    43426.405554908022	    46742.075095073822	    53316.719651374595	;
   -53069.510340597459	   -50771.484689356774	   -48429.987919985753	   -45949.860544464653	   -43662.819594502209	   -41298.389264763631	   -38838.743400365580	   -36330.364994308919	   -33662.982274564631	   -31035.697371587521	   -28357.532536543509	   -25629.260916916668	   -22833.740645233793	   -19966.219843226820	   -17076.264320260998	   -14164.030825866843	   -11226.685075946807	   -8298.0854318721595	   -3932.1150776949521	    609.39319356760359	    3821.8290211896851	    7148.5035876653546	    10494.811226248192	    13840.516480680457	    17178.032965905611	    20538.456568361562	    23919.706560006747	    27322.281216507723	    30793.452536997644	    34328.681623613280	    37911.623798904271	    41542.997592225933	    45136.158391511490	    48880.863187967807	    52672.578258104040	    56556.092433669364	    60511.805138804935	    64267.663728262742	    72182.796432218689	;
   -74761.964026593691	   -71161.559690311027	   -67562.246622763589	   -63970.116057226405	   -60394.591891720287	   -56842.716818145978	   -53320.056959088295	   -49829.553498324000	   -46381.784259870547	   -42800.382996504173	   -39058.219808839451	   -35168.030645110928	   -31229.740640884069	   -27276.917952705833	   -23289.363941235126	   -19301.276076639089	   -15313.524484746018	   -11317.684579816028	   -5379.2334212558189	    700.00054110766371	    4969.3123632218521	    9366.4470385174827	    13751.025503138613	    18125.851540684398	    22508.022082020892	    26888.433193104996	    31268.856393307975	    35682.321691280456	    40109.668045274171	    44582.836333915795	    49196.910115134335	    53963.881522823642	    58858.189684858582	    63714.213011738007	    68547.831523389774	    73359.923070293109	    78154.456102104494	    82937.029222291429	    92481.485151625107	;
   -95553.637170591697	   -90841.590553504502	   -86131.627269465971	   -81426.829408388308	   -76730.533752695206	   -72046.888910008871	   -67379.701916075486	   -62732.151429605423	   -58107.486559776175	   -53510.161163885714	   -48948.688741612292	   -44431.485702615566	   -39738.141042704396	   -34874.888378006523	   -29891.323132588972	   -24851.070259592714	   -19724.719688312500	   -14537.104522813926	   -6920.2058491570369	    771.24084547254245	    6062.1784932014434	    11454.136727210165	    16815.246617861852	    22104.257621926183	    27446.003047980001	    32868.194984388574	    38344.340380332622	    43935.146751275315	    49687.836802736048	    55609.094512031588	    61491.122228759014	    67341.830503591875	    73169.432748602499	    78978.396333095108	    84771.970723500039	    90553.045487521595	    96324.760851235624	    102090.26526982724	    113603.06512722879	;
   -115824.57059835564	   -110055.86806606986	   -104287.29441500150	   -98518.908400100656	   -92750.559516977009	   -86981.871523601978	   -81212.420409115570	   -75442.275268258250	   -69673.114619110929	   -63910.149983195261	   -58164.968855852640	   -52461.055845550618	   -46842.086162198713	   -41381.900690429902	   -35679.676213952327	   -29765.600099244319	   -23739.776154107174	   -17630.626095616673	   -8270.6525007638720	    1109.3157407549104	    7380.7955749581224	    13678.187796526199	    20015.513486858905	    26457.480837195682	    32986.427803660772	    39622.026000814505	    46458.719075230605	    53526.283682586538	    60444.878337397415	    67284.678938877521	    74087.243670853000	    80874.910646784716	    87658.627718360425	    94443.175834588794	    101229.88043111708	    108018.47859457528	    114808.20947730356	    121598.37440638476	    135178.87527210047	;
   -135736.35183216885	   -128943.95576744604	   -122151.70616878133	   -115360.13479257301	   -108570.39993126557	   -101784.52075005378	   -95005.567309088292	   -88237.714497873501	   -81486.009525852409	   -74755.648190228108	   -68050.529675419064	   -61370.917163507584	   -54710.237880864915	   -48051.646737103532	   -41368.273726273954	   -34630.657196748034	   -27710.667751910925	   -20672.210271567132	   -9983.9231973447640	    888.24714319005614	    8258.5499994565325	    15723.674255015643	    23250.237673131636	    30853.501117286418	    38575.759692657077	    46471.824586612624	    54419.744202188798	    62391.719872640650	    70362.440787374304	    78316.079992197323	    86246.500653089475	    94153.989118802114	    102042.22110214684	    109916.05231541433	    117780.16178368004	    125638.37841603288	    133493.46670840020	    141347.17399397033	    157052.40449023707	;
   -155437.05421917560	   -147652.77046916573	   -139869.26307240894	   -132087.96065300400	   -124310.79466728077	   -116539.98681068476	   -108777.73721801012	   -101025.79634044869	   -93284.943055572498	   -85554.451791458603	   -77831.702714398329	   -70112.145492199124	   -62389.820749705177	   -54658.484865818027	   -46912.965522316459	   -39149.615374776324	   -31368.644579743086	   -23432.065168875837	   -11312.533520664139	    1121.2957961544753	    9546.5038106430165	    18081.969551575647	    26757.857396337015	    35547.982717520383	    44493.877551521582	    53455.134315578180	    62432.683883935417	    71423.518035766116	    80422.957243872515	    89425.158500059959	    98424.474900058587	    107416.57970038698	    116398.99624583389	    125371.07704067809	    134333.62811321934	    143288.38148217986	    152237.46440137632	    161182.94548294871	    179065.14930323500	;
   -175059.39302718613	   -166288.82836238126	   -157518.66860137932	   -148749.56899808918	   -139982.28907379266	   -131217.57017239393	   -122456.05536270345	   -113698.26746206296	   -104944.64668856503	   -96195.619271929492	   -87451.621396442366	   -78712.947149103318	   -69979.247905748562	   -61248.527170280526	   -52515.612023864982	   -43770.406326854798	   -34996.749310969280	   -26173.309659778737	   -12733.418145931038	    1144.1883231888901	    10680.960306662504	    20412.883754535243	    30279.465463232274	    40266.205949805590	    50302.155106334772	    60366.129446819468	    70441.935618061238	    80519.286465279394	    90592.778053136601	    100660.25576074426	    110721.34755548020	    120776.46425887659	    130826.26349266036	    140871.44239752894	    150912.70456131763	    160950.78156690139	    170986.43915251645	    181020.44043219136	    201084.05254929553	;
   -194654.67698513149	   -184890.25008284434	   -175125.90045019763	   -165361.70906746085	   -155597.68929771410	   -145833.72404537647	   -136069.52384799221	   -126304.62749214956	   -116538.47964976296	   -106770.63655450258	   -97001.168008627705	   -87231.333799046595	   -77464.598237459402	   -67707.980651765436	   -57973.585359033903	   -48279.874562840509	   -38651.826369982577	   -29118.605369709290	   -14343.052244836517	    1120.5782258726379	    11715.442187846134	    22527.677995015136	    33618.812739396220	    44960.603857572503	    56216.960077877389	    67412.028294918942	    78567.146077035766	    89698.633279495451	    100817.69057448581	    111931.28418064433	    123043.30394730142	    134155.62338740777	    145268.92014552478	    156383.24363978853	    167498.37286612298	    178614.02146955294	    189729.94139404796	    200845.96417872392	    223078.09915685249	;
   -214231.75758093849	   -203468.90515502513	   -192706.00308690296	   -181943.03613694379	   -171180.10637639835	   -160417.51092028560	   -149655.80593768487	   -138895.84284735634	   -128138.75735216393	   -117385.88954246900	   -106638.61798811246	   -95898.109002940982	   -85165.022698057786	   -74439.289430266435	   -63720.180059329774	   -53007.035862185410	   -42301.167821370691	   -31609.501602426626	   -15648.283778590583	    1302.4806849416564	    13000.962757487947	    24997.794168962806	    37357.925214803807	    49661.361815723554	    61931.406837647861	    74180.739383235123	    86415.919262234529	    98640.451281974005	    110856.56423984913	    123066.06795837868	    135270.65052737662	    147471.89381470025	    159671.18747595130	    171869.64052855870	    184068.03331661716	    196266.81915756915	    208466.16831732768	    220666.04124637228	    245067.42641398858	;
   -233791.38399349677	   -222036.27401571421	   -210281.11115574016	   -198525.88506447474	   -186770.72532398478	   -175016.00268083991	   -163262.43353441067	   -151511.18184635401	   -139763.94363908953	   -128022.98520477637	   -116291.08559325122	   -104571.30585508735	   -92866.472480387369	   -81178.224905628260	   -69505.448682601753	   -57841.921502006597	   -46173.083097492199	   -34472.073689135505	   -16743.859404853905	    1736.0744463647693	    14470.750115211407	    27498.636512627516	    40761.527024509916	    54084.515795723171	    67433.188967374997	    80786.316585251174	    94132.644426698243	    107467.64791292706	    120790.84918339782	    134103.85948612355	    147409.08963676987	    160708.98658470347	    174005.64257961366	    187300.64536337255	    200595.07026634066	    213889.54644239575	    227184.35500592654	    240479.53555049002	    267071.12992103695	;
   -253339.51076458493	   -240600.22972962281	   -227861.05836378795	   -215122.13888651165	   -202383.56736759766	   -189645.31203781351	   -176907.12919196757	   -164168.48122536647	   -151428.46748799764	   -138685.78716448147	   -125938.76428721282	   -113185.47773423072	   -100424.05205419019	   -87653.174701753887	   -74872.905184812276	   -62085.820574877558	   -49298.482510351438	   -36523.088716737955	   -17433.266760237842	    2352.7841194099710	    16228.966647891046	    30511.858398142849	    44783.541872393711	    59060.084088232368	    73351.654416933117	    87663.153996351743	    101995.51016254206	    116347.06331261322	    130714.76013857922	    145095.04933546839	    159484.47853237166	    173880.03978661777	    188279.32644923098	    202680.56167363506	    217082.54817290459	    231484.57587825140	    245886.31198532184	    260287.68783703394	    289089.20593803411	]; 
mg.unpowered_torque_loss_Nm = class_REVS_dynamic_lookup;
mg.unpowered_torque_loss_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.unpowered_torque_loss_Nm.axis_1.breakpoints = [	    -15000.000000000000	    15000.000000000000		]; 
mg.unpowered_torque_loss_Nm.table = [	     0.0000000000000000	    0.0000000000000000		]; 
